/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.iw.tasks.networksettings;

import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.common.util.HSCLocalizableMsg;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.iw.WizardTaskBean;
import com.ibm.hsc.iw.WizardTaskException;
import com.ibm.hsc.iw.tasks.networksettings.NetworkSettingsConstants;
import com.ibm.hsc.iw.tasks.networksettings.NetworkSettingsValidation;
import com.ibm.hwmca.base.settings.network.NetworkInfo;
import com.ibm.hwmca.fw.log.ClassLogInfo;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.UserTaskManager;
import com.ibm.ui.framework.ValueDescriptor;
import java.io.Serializable;

public class NetworkSettings11DNSBean
extends WizardTaskBean
implements NetworkSettingsConstants {
    public static final String BEAN_NAME = "NetworkSettings11DNSBean";
    private static final String TRACE_MASKD = "JNSWNSBD";
    private static final String TRACE_MASKF = "JNSWNSBF";
    private static final String TRACE_MASKT = "JNSWNSBT";
    static final short ERRID_0001 = 1;
    static final short ERRID_0002 = 2;
    static final short ERRID_0003 = 3;
    static final short ERRID_0004 = 4;
    static final short ERRID_0005 = 5;
    static final short ERRID_0006 = 6;
    static ClassLogInfo LOG_INFO = new ClassLogInfo(-88, 126, "NetSetBBean");
    private static final String GROUP_BOX = "Group1";
    private static final String DNS_SERVER_ADDRESS = "DNSServerAddress";
    private static final String DNS_SERVER_SEARCH_ORDER = "DNSServerSearchOrder";
    private static final String ADD_BUTTON = "AddButton";
    private static final String REMOVE_BUTTON = "RemoveButton";
    private boolean m_bEnableDNS;
    private String m_sDNSServerAddress;
    private String m_sDNSSearchOrder;
    private ValueDescriptor[] m_vdDNSSearchOrder;
    private String[] m_sDNSServers;
    private boolean m_bChangeFlag;
    private boolean m_bChangedSinceLastUpdate;

    public NetworkSettings11DNSBean() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings11DNSBean Default Constructor");
        }
        this.m_bEnableDNS = false;
        this.m_sDNSServerAddress = "";
        this.m_sDNSSearchOrder = "";
        this.m_vdDNSSearchOrder = new ValueDescriptor[0];
        this.m_sDNSServers = new String[0];
        this.m_bChangeFlag = false;
        this.m_bChangedSinceLastUpdate = false;
        this.setBeanName(BEAN_NAME);
    }

    public NetworkSettings11DNSBean(NetworkSettings11DNSBean networkSettings11DNSBean) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings11DNSBean NetworkSettings11DNSBean Constructor");
        }
        this.bean11Copy(networkSettings11DNSBean);
        this.m_bChangeFlag = false;
        this.m_bChangedSinceLastUpdate = false;
    }

    public NetworkSettings11DNSBean(Object object) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings11DNSBean Object Constructor");
        }
        String string = ((PanelBean)object).getBeanName();
        if (2 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKF, "--NetworkSettings11DNSBean Object passed is: " + string);
        }
        if (string != null && string.length() > 0) {
            if (string.equals(BEAN_NAME)) {
                this.bean11Copy((NetworkSettings11DNSBean)object);
                this.m_bChangeFlag = ((NetworkSettings11DNSBean)object).isChanged();
                this.m_bChangedSinceLastUpdate = ((NetworkSettings11DNSBean)object).isChangedSinceLastUpdate();
            } else {
                this.m_bEnableDNS = false;
                this.m_sDNSServerAddress = "";
                this.m_sDNSSearchOrder = "";
                this.m_vdDNSSearchOrder = new ValueDescriptor[0];
                this.m_sDNSServers = new String[0];
                this.m_bChangeFlag = false;
                this.m_bChangedSinceLastUpdate = false;
                this.setBeanName(BEAN_NAME);
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "--NetworkSettings11DNSBean ERROR - incorrect object passed on object constructor:" + string);
                }
                new AusMicrocodeLog(LOG_INFO, 2, new Exception(string)).writeEntryFromTaskletClient();
            }
        } else {
            this.m_bEnableDNS = false;
            this.m_sDNSServerAddress = "";
            this.m_sDNSSearchOrder = "";
            this.m_vdDNSSearchOrder = new ValueDescriptor[0];
            this.m_sDNSServers = new String[0];
            this.m_bChangeFlag = false;
            this.m_bChangedSinceLastUpdate = false;
            this.setBeanName(BEAN_NAME);
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "--NetworkSettings11DNSBean ERROR - incorrect object passed on object constructor");
            }
            new AusMicrocodeLog(LOG_INFO, 3).writeEntryFromTaskletClient();
        }
    }

    private void bean11Copy(NetworkSettings11DNSBean networkSettings11DNSBean) {
        this.m_bEnableDNS = networkSettings11DNSBean.isEnableDNS();
        this.m_sDNSServerAddress = networkSettings11DNSBean.getDNSServerAddress();
        this.m_sDNSSearchOrder = networkSettings11DNSBean.getDNSSearchOrder();
        this.m_vdDNSSearchOrder = new ValueDescriptor[0];
        this.m_sDNSServers = networkSettings11DNSBean.getDNSServers();
        this.setBeanName(networkSettings11DNSBean.getBeanName());
    }

    public void setEnableDNS(boolean bl) throws IllegalUserDataException {
        this.m_bEnableDNS = bl;
        this.m_bChangeFlag = true;
        this.m_bChangedSinceLastUpdate = true;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings11DNSBean setEnableDNS called enableDNS =" + bl);
        }
        if (this.userTaskManager != null && this.getMountPrefix() != null) {
            if (this.isEnableDNS()) {
                this.userTaskManager.setEnabled(this.getMountPrefix() + GROUP_BOX, true);
                this.userTaskManager.setEnabled(this.getMountPrefix() + DNS_SERVER_ADDRESS, true);
                this.userTaskManager.setSelected(this.getMountPrefix() + DNS_SERVER_ADDRESS, true);
                this.userTaskManager.setEnabled(this.getMountPrefix() + DNS_SERVER_SEARCH_ORDER, true);
                this.userTaskManager.setEnabled(this.getMountPrefix() + ADD_BUTTON, true);
                this.userTaskManager.setEnabled(this.getMountPrefix() + REMOVE_BUTTON, true);
            } else {
                this.userTaskManager.setEnabled(this.getMountPrefix() + GROUP_BOX, false);
                this.userTaskManager.setEnabled(this.getMountPrefix() + DNS_SERVER_ADDRESS, false);
                this.userTaskManager.setEnabled(this.getMountPrefix() + DNS_SERVER_SEARCH_ORDER, false);
                this.userTaskManager.setEnabled(this.getMountPrefix() + ADD_BUTTON, false);
                this.userTaskManager.setEnabled(this.getMountPrefix() + REMOVE_BUTTON, false);
            }
        }
    }

    public boolean isEnableDNS() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings11DNSBean isEnableDNS called returning " + this.m_bEnableDNS);
        }
        return this.m_bEnableDNS;
    }

    public synchronized void setDNSServerAddress(String string) throws IllegalUserDataException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings11DNSBean setDNSServerAddress called address = " + string);
        }
        this.m_sDNSServerAddress = string.trim();
        this.m_bChangeFlag = true;
        this.m_bChangedSinceLastUpdate = true;
    }

    public String getDNSServerAddress() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings11DNSBean getDNSServerAddress called");
        }
        return this.m_sDNSServerAddress;
    }

    public ValueDescriptor[] getDNSSearchOrderList() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings11DNSBean getDNSSearchOrderList called");
        }
        return this.m_vdDNSSearchOrder;
    }

    private synchronized void setDNSSearchOrderList(ValueDescriptor[] valueDescriptorArray) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings11DNSBean setDNSSearchOrderList called");
        }
        this.m_vdDNSSearchOrder = valueDescriptorArray;
    }

    public synchronized void setDNSSearchOrder(String string) throws IllegalUserDataException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings11DNSBean setDNSSearchOrder called with " + string);
        }
        this.m_sDNSSearchOrder = string.trim();
        this.m_bChangeFlag = true;
        this.m_bChangedSinceLastUpdate = true;
    }

    public String getDNSSearchOrder() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings11DNSBean getDNSSearchOrder called");
        }
        return this.m_sDNSSearchOrder;
    }

    public String[] getDNSServers() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings11DNSBean getDNSServers called");
        }
        return this.m_sDNSServers;
    }

    public synchronized void setDNSServers(String[] stringArray) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings11DNSBean setDNSServers called");
        }
        this.m_sDNSServers = stringArray;
        this.m_bChangeFlag = true;
        this.m_bChangedSinceLastUpdate = true;
    }

    public boolean isChanged() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings11DNSBean isChanged returning " + this.m_bChangeFlag);
        }
        return this.m_bChangeFlag;
    }

    public boolean isChangedSinceLastUpdate() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings11DNSBean isChangedSinceLastUpdate returning " + this.m_bChangedSinceLastUpdate);
        }
        return this.m_bChangedSinceLastUpdate;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void load() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings11DNSBean load called");
        }
        this.m_sDNSSearchOrder = "";
        int n = this.m_sDNSServers != null ? this.m_sDNSServers.length : 0;
        this.m_vdDNSSearchOrder = new ValueDescriptor[n];
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                this.m_vdDNSSearchOrder[i] = new ValueDescriptor(this.m_sDNSServers[i], this.m_sDNSServers[i]);
                if (2 > Trace.LEVEL) continue;
                Trace.trace(TRACE_MASKF, "--NetworkSettings11DNSBean load DNSSearchOrder[" + i + "] = " + this.m_sDNSServers[i]);
            }
        }
    }

    public Serializable nextButtonHit() throws WizardTaskException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings11DNSBean nextButtonHit called");
        }
        return new NetworkSettings11DNSBean((Object)this);
    }

    public Serializable backButtonHit() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings11DNSBean backButtonHit called");
        }
        return new NetworkSettings11DNSBean((Object)this);
    }

    public void updateBean(NetworkSettings11DNSBean networkSettings11DNSBean) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings11DNSBean updateBean called");
        }
        if (networkSettings11DNSBean.isChangedSinceLastUpdate()) {
            this.setEnableDNS(networkSettings11DNSBean.isEnableDNS());
            this.setDNSServerAddress(networkSettings11DNSBean.getDNSServerAddress());
            this.setDNSSearchOrder(networkSettings11DNSBean.getDNSSearchOrder());
            this.setDNSServers(networkSettings11DNSBean.getDNSServers());
        }
    }

    public void setNetworkInfo(NetworkInfo networkInfo) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings11DNSBean setNetworkInfo called");
        }
        this.m_bEnableDNS = networkInfo.isDNSEnabled();
        if (networkInfo.getDNSServers() != null && networkInfo.getDNSServers().length > 0) {
            this.m_sDNSServers = networkInfo.getDNSServers();
        }
    }

    public void updateNetworkInfo(NetworkInfo networkInfo) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings11DNSBean updateNetworkInfo called");
        }
        if (this.isChangedSinceLastUpdate()) {
            networkInfo.setDNSEnabled(this.isEnableDNS());
            if (this.getDNSServers() != null) {
                networkInfo.setDNSServers(this.getDNSServers());
            }
            this.m_bChangedSinceLastUpdate = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void panelAction(TaskActionEvent taskActionEvent) {
        String string = null;
        String string2 = null;
        UserTaskManager userTaskManager = null;
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "->panelAction() : \n\tBean Name     : " + this.getBeanName() + "\n\tCurrentElement: " + taskActionEvent.getCurrentElement() + "\n\tElementName   : " + taskActionEvent.getElementName() + "\n\tActionCommand : " + taskActionEvent.getActionCommand());
        }
        if (taskActionEvent != null) {
            string = taskActionEvent.getElementName();
            string2 = taskActionEvent.getActionCommand();
            userTaskManager = this.getUserTaskManager();
            if (string.endsWith(ADD_BUTTON)) {
                String string3 = this.getDNSServerAddress().trim();
                if (string3.length() > 0) {
                    int n = NetworkSettingsValidation.validateIPAddress(string3);
                    if (n != 0) {
                        if (2 <= Trace.LEVEL) {
                            Trace.trace(TRACE_MASKF, "--NetworkSettings11DNSBean AddButton ERROR - DNS server invalid- validateIPAddress rc = " + n);
                        }
                        if (userTaskManager != null) {
                            Object[] objectArray = new Object[]{new String(string3)};
                            try {
                                NetworkSettings11DNSBean.showMessageBox(userTaskManager, new LocalizableText("com.ibm.hsc.common.bundles.NetworkSettingsText", "NETWORKSETTINGS_ERROR_TITLE", null), new HSCLocalizableMsg(MsgType.ERROR_MESSAGE, "W", "com.ibm.hsc.common.bundles.GuidedSetupWizardMessages", "1067", objectArray));
                            }
                            catch (Exception exception) {
                                if (Trace.LEVEL >= 2) {
                                    Trace.trace(TRACE_MASKF, "--NetworkSettings11DNSBean panelAction Add ERROR - showMessageBox exception: " + exception.toString());
                                }
                                new AusMicrocodeLog(LOG_INFO, 4, exception).writeEntryFromTaskletClient();
                            }
                        }
                    } else {
                        int n2 = this.getDNSSearchOrderList().length;
                        boolean bl = false;
                        String[] stringArray = this.getDNSServers();
                        for (int i = 0; i < n2; ++i) {
                            if (!stringArray[i].equals(string3)) continue;
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            ValueDescriptor[] valueDescriptorArray = new ValueDescriptor[n2 + 1];
                            String[] stringArray2 = new String[n2 + 1];
                            if (n2 > 0) {
                                for (int i = 0; i < n2; ++i) {
                                    valueDescriptorArray[i] = this.getDNSSearchOrderList()[i];
                                    stringArray2[i] = this.getDNSServers()[i];
                                }
                            }
                            valueDescriptorArray[n2] = new ValueDescriptor(string3, string3);
                            stringArray2[n2] = string3;
                            NetworkSettings11DNSBean networkSettings11DNSBean = this;
                            synchronized (networkSettings11DNSBean) {
                                this.setDNSServerAddress("");
                                this.setDNSSearchOrderList(valueDescriptorArray);
                                this.setDNSSearchOrder(string3);
                                this.setDNSServers(stringArray2);
                            }
                            userTaskManager.refreshAllElements();
                        } else {
                            if (Trace.LEVEL >= 2) {
                                Trace.trace(TRACE_MASKF, "--NetworkSettings11DNSBean panelAction Add - DNS server duplicate");
                            }
                            NetworkSettings11DNSBean networkSettings11DNSBean = this;
                            synchronized (networkSettings11DNSBean) {
                                this.setDNSServerAddress("");
                            }
                            userTaskManager.refreshAllElements();
                        }
                    }
                } else if (userTaskManager != null) {
                    if (Trace.LEVEL >= 2) {
                        Trace.trace(TRACE_MASKF, "--NetworkSettings11DNSBean panelAction Add ERROR - DNS server not entered");
                    }
                    try {
                        NetworkSettings11DNSBean.showMessageBox(userTaskManager, new LocalizableText("com.ibm.hsc.common.bundles.NetworkSettingsText", "NETWORKSETTINGS_ERROR_TITLE", null), new HSCLocalizableMsg(MsgType.ERROR_MESSAGE, "W", "com.ibm.hsc.common.bundles.GuidedSetupWizardMessages", "1091", null));
                    }
                    catch (Exception exception) {
                        if (Trace.LEVEL >= 2) {
                            Trace.trace(TRACE_MASKF, "--NetworkSettings11DNSBean panelAction Add ERROR - showMessageBox exception: " + exception.toString());
                        }
                        new AusMicrocodeLog(LOG_INFO, 5, exception).writeEntryFromTaskletClient();
                    }
                }
            } else if (string.endsWith(REMOVE_BUTTON)) {
                String string4 = this.getDNSSearchOrder().trim();
                if (string4.length() > 0) {
                    Object object;
                    int n = this.getDNSSearchOrderList().length;
                    ValueDescriptor[] valueDescriptorArray = new ValueDescriptor[n - 1];
                    String[] stringArray = new String[n - 1];
                    if (n - 1 > 0) {
                        int n3 = 0;
                        for (int i = 0; i < n; ++i) {
                            object = this.getDNSSearchOrderList()[i].getTitle().trim();
                            if (string4.equals(object)) continue;
                            valueDescriptorArray[n3] = this.getDNSSearchOrderList()[i];
                            stringArray[n3++] = object;
                        }
                    }
                    object = this;
                    synchronized (object) {
                        this.setDNSSearchOrderList(valueDescriptorArray);
                        this.setDNSServers(stringArray);
                        if (n - 1 > 0) {
                            this.setDNSSearchOrder(valueDescriptorArray[n - 2].getTitle());
                        } else {
                            this.setDNSSearchOrder("");
                        }
                    }
                    userTaskManager.refreshAllElements();
                } else if (userTaskManager != null) {
                    if (Trace.LEVEL >= 2) {
                        Trace.trace(TRACE_MASKF, "--NetworkSettings11DNSBean panelAction Remove ERROR - DNS server not selected");
                    }
                    try {
                        NetworkSettings11DNSBean.showMessageBox(userTaskManager, new LocalizableText("com.ibm.hsc.common.bundles.NetworkSettingsText", "NETWORKSETTINGS_ERROR_TITLE", null), new HSCLocalizableMsg(MsgType.ERROR_MESSAGE, "W", "com.ibm.hsc.common.bundles.GuidedSetupWizardMessages", "1092", null));
                    }
                    catch (Exception exception) {
                        if (Trace.LEVEL >= 2) {
                            Trace.trace(TRACE_MASKF, "--NetworkSettings11DNSBean panelAction Remove ERROR - showMessageBox exception: " + exception.toString());
                        }
                        new AusMicrocodeLog(LOG_INFO, 6, exception).writeEntryFromTaskletClient();
                    }
                }
            } else {
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "Unknown event received in panelAction(...).");
                }
                new AusMicrocodeLog(LOG_INFO, 1).writeEntryFromTaskletClient();
            }
        }
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<-NetworkSettings11DNSBean panelAction(...)");
        }
    }

    public void prepare() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->NetworkSettings11DNSBean prepare called");
        }
        if (2 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKF, "--NetworkSettings11DNSBean prepare getMountPrefix = " + this.getMountPrefix());
        }
        if (2 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKF, "--NetworkSettings11DNSBean prepare isEnableDNS = " + this.isEnableDNS());
        }
        if (this.isEnableDNS()) {
            this.userTaskManager.setEnabled(this.getMountPrefix() + GROUP_BOX, true);
            this.userTaskManager.setEnabled(this.getMountPrefix() + DNS_SERVER_ADDRESS, true);
            this.userTaskManager.setSelected(this.getMountPrefix() + DNS_SERVER_ADDRESS, true);
            this.userTaskManager.setEnabled(this.getMountPrefix() + DNS_SERVER_SEARCH_ORDER, true);
            this.userTaskManager.setEnabled(this.getMountPrefix() + ADD_BUTTON, true);
            this.userTaskManager.setEnabled(this.getMountPrefix() + REMOVE_BUTTON, true);
        } else {
            this.userTaskManager.setEnabled(this.getMountPrefix() + GROUP_BOX, false);
            this.userTaskManager.setEnabled(this.getMountPrefix() + DNS_SERVER_ADDRESS, false);
            this.userTaskManager.setEnabled(this.getMountPrefix() + DNS_SERVER_SEARCH_ORDER, false);
            this.userTaskManager.setEnabled(this.getMountPrefix() + ADD_BUTTON, false);
            this.userTaskManager.setEnabled(this.getMountPrefix() + REMOVE_BUTTON, false);
        }
    }
}

